<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "setOULeerling opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['gebruikersnaam']) && strlen($_GET['gebruikersnaam']) > 1){
		show_error_and_log($logfolder, "setOULeerling opgevraagd zonder gebruikersnaam van de leraar");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "setOULeerling opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}
	
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "setOULeerling opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) lerarenid");
		exit;
	}
				
				
	$gebruikersnaam = $_GET['gebruikersnaam'];
	$session_hash   = $_GET['session_hash']; 
	$lerarenid	    = $_GET['lerarenid'];
	
	$verify_url = $toolbox_url.'/public/validate_ad_setou_leerling_bs.php?session_hash='.$session_hash.'&key='.$ad_key.'&gebruikersnaam='.$gebruikersnaam;

	$return = file_get_contents($verify_url);				
	$return = json_decode($return);
		
	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object) voor setOULeerling");
		exit;
	}	

	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor setOULeerling");
		exit;
	}	
	
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor setOULeerling");
		exit;
	}
	
							
	$samaccountname = substr($return->gebruikersnaam,0, 20);
	$ou  			= $return->ou;
	$ou  			= $return->ou;
	$empnr 			= $return->pointer;
	
	$arr_data = array();
	exec("powershell -file C:\\toolbox\\powershell\\setOU.ps1 -samaccountname \"$samaccountname\" -empnr \"$empnr \" -userid \"$gebruikersnaam\" -ou \"$ou\"",$arr_data);
	
	if(count($arr_data) == 0){
		log_to_file($logfolder, "setOULeerling uitgevoerd voor $samaccountname door lerarenid $lerarenid vanuit ip $ip");
		echo "1";
	}
	else{
		log_to_file($logfolder, "setOULeerling niet uitgevoerd voor $samaccountname door lerarenid $lerarenid vanuit ip $ip: ".serialize(json_encode($arr_data)));
		echo json_encode($arr_data);
	}

?>